//
//  MCMenuManagerSupportProtocol.h
//  MCApplication
//
//  Created by Ali Lalani on 10/11/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@protocol MCMenuManagerSupport <NSObject>
@optional
//FIXME: Fix this when we're 10.6+
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
// Forward to the menu manager if the selector has prefix @"__"
- (BOOL)validateMenuItem:(NSMenuItem*)menuItem;

// if super doesn't respond, forward to the menu manager
- (BOOL)respondsToSelector:(SEL)aSelector;

// if super doesn't return one, get it from the menu manager and return that
- (NSMethodSignature *)methodSignatureForSelector:(SEL)aSelector;

// if the menu manager returns no, pass it to super to deal with
- (void)forwardInvocation:(NSInvocation *)anInvocation;

// returns the objects to act upon, that essentially have selection in your view
- (NSArray *)selectedObjects;

// returns all objects in the list in question
- (NSArray *)allObjects;
@end
